* Title: 	figure10.do
* Version: 	23 May 2018
* Purpose: 	Produce graph of LT jobless change


*******************************************************************************
* (0) Start of file
*******************************************************************************

capture log close
log using output/figures/log/figure10, text replace
set more off
clear all
macro drop _all


*******************************************************************************
* (1) Load data
*******************************************************************************

use year statefip PrimeMaleD LTJoblessB wtsupp ///
	using dta/asec_clean, clear

* Keep only prime-age men
keep if PrimeMaleD == 1

* Keep only continental 48 states (excluding District of Columbia)
drop if (statefip == 02 | statefip == 11 | statefip == 15 | statefip>56)


*******************************************************************************
* (2) Construct rates for joblessness categories
*******************************************************************************

collapse (sum) Total = PrimeMaleD LTJobless = LTJoblessB ///
		 [pw=wtsupp], by(statefip year)

xtset statefip year
gen LTJobless_Rate = 100 * (L.LTJobless + LTJobless + F.LTJobless) / (L.Total + Total + F.Total)

keep year statefip LTJobless_Rate 
keep if (year == 1980 | year == 2014)
reshape wide LTJobless_Rate, i(statefip) j(year)

gen Delta_LTJobless = LTJobless_Rate2014 - LTJobless_Rate1980
keep statefip LTJobless_Rate1980 Delta_LTJobless

* Save dataset
compress
save output/figures/dta/figure10.dta, replace


*******************************************************************************
* (3) Produce regression/graph
*******************************************************************************

reg Delta_LTJobless LTJobless_Rate1980
		
scatter Delta_LTJobless LTJobless_Rate1980 || lfit Delta_LTJobless LTJobless_Rate1980, lc(black) ///
		legend(label(1 "State Average Not Working Rate")) ///
		graphregion(color(white)) bgcolor(white) ///
		xtitle("Mean long-term not working rate 1980") ///
		ytitle("Change in long-term not working rate 1980-2014")

graph save output/figures/gph/figure10, replace
graph export output/figures/eps/figure10.eps, as(eps) replace
export excel using output/figures/xlsx/figure10.xlsx, first(variables) replace


*******************************************************************************
* (4) End of file
*******************************************************************************

log close
exit, clear
